/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package solution;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Utilities {

    /*    public static String capitalise(String s){
        //Convert the incoming string to an array of words (strings separated by spaces)
        String[] words = s.split(" ");
        //variable to store the results
        String formattedString="";
        //Loop through each word, formatting it and then adding it to our result.
        for (String word: words){
            formattedString=formattedString//Take what we have done so far...
                    +word.substring(0,1).toUpperCase()//add the first letter of the word as upper case
                    +word.substring(1).toLowerCase()//add the rest of the word in lower case
                    +" ";//add a space ready for the next word.
        }
        //We have an extra space at the end of our string so remove it with trim
        formattedString=formattedString.trim();
        return formattedString;
    }
     */
    //String Builder version
    public static String capitalise(String s) {
        //Convert the incoming string to an array of words (strings separated by spaces)
        String[] words = s.split(" ");//split only available for String class.
        //variable to store the results
        StringBuilder formattedString = new StringBuilder("");
        //Loop through each word, formatting it and then adding it to our result.
        for (String word : words) {
            //Use append to add a string to the string builder.
            formattedString = formattedString
                    .append(word.substring(0, 1).toUpperCase())
                    .append(word.substring(1).toLowerCase())
                    .append(" ");
        }
        //Remove the space from the end of the string.  trim is not available for StringBuilder class
        formattedString = formattedString.deleteCharAt(formattedString.length() - 1);

        //must convert from StringBuilder back to String before returning
        return formattedString.toString();
    }
}
